
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/dutyskat.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
"duty_skat",
"scroll",
}

local function flight (inst)
	if (inst.components.health:GetPercent() < .4) and inst:HasTag("combatskat")  then
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7.5
	inst.components.health:DoDelta(1,1)
	inst.components.sanity:DoDelta(-1,-1)
	inst.components.hunger:DoDelta(-1,-1)
	else
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end
end




local fn = function(inst)

local function sanityfn(inst)
local x,y,z = inst.Transform:GetWorldPosition()
local delta = 0
local max_rad = 10
local ents = TheSim:FindEntities(x,y,z, max_rad, nil, nil, {"freedom", "pig", "king"})
    for k,v in pairs(ents) do 
if not (v.components.health and v.components.health:IsDead()) then
local sz = -TUNING.SANITYAURA_MED
local rad = 10
sz = sz * ( math.min(max_rad, rad) / max_rad )
local distsq = inst:GetDistanceSqToInst(v)
delta = delta + sz/math.max(1, distsq)
    end
    end
    
    return delta
end

local duty_skat = Ingredient( "duty_skat", 1)
duty_skat.atlas = "images/inventoryimages/duty_skat.xml"
local armor_device = Recipe("duty_skat", { Ingredient("goldnugget", 23), duty_skat }, RECIPETABS.REFINE, {REFINE=0})
armor_device.atlas = "images/inventoryimages/duty_skat.xml"


inst.soundsname = "duty"
	inst:AddTag("duty")
	inst:AddTag("stalker")
	inst.MiniMapEntity:SetIcon( "dutyskat.tex" )	

inst.components.sanity.custom_rate_fn = sanityfn

	inst.components.sanity.night_drain_mult = 0.75
	inst.components.sanity.neg_aura_mult = 0.75

	-- Stats	
	inst.components.health:SetMaxHealth(185)
	inst.components.hunger:SetMax(185)
	inst.components.sanity:SetMax(200)
	
	inst:DoPeriodicTask(5, flight, nil, inst)

end

return MakePlayerCharacter("dutyskat", prefabs, assets, fn, start_inv)
